
//adapted from Original https://www.shadertoy.com/view/fdB3zh
// Random Procedural Textures 4 by jarble at Shadertoy.com
// Licence CC0
// Adapted, trivialy, for use in VGHD player by ET.


uniform float u_Elapsed; // The time elapsed in seconds since the beginning of the scene.
uniform vec2 u_WindowSize;  // This is the dimensions of the viewport.
// -----------------------------------------------------------------------------
#define iTime   u_Elapsed* 0.366 
//#define texture2D texture2D_Fract
//#define iGlobalTime u_Elapsed* 0.166
//#define RESOLUTION      iResolution
#define iResolution      u_WindowSize
#define iMouse AUTO_MOUSE
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
uniform sampler2D iChannel0;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
//
//vec3 c1 = vec3(6.2,6.4,1.1); //change this constant to get different patterns!
vec3 c1 = vec3(7.2,7.4,1.1);
//vec3 c1 = vec3(8.0,8.2,1.1);
//vec3 c1 = vec3(8.0,9.0,1.1);
//vec3 c1 = vec3(2.0,2.7,1.07);
//vec3 c1 = vec3(9.8,10.0,1.1);

//----------------------------------------------------------------------------------------
//  1 out, 1 in...
float hash11(float p)
{
    p = fract(p * .1031);
    p *= p + 33.33;
    p *= p + p;
    return fract(p);
}

//----------------------------------------------------------------------------------------
//  3 out, 1 in...
vec3 hash31(float p)
{
   vec3 p3 = fract(vec3(p) * vec3(.1031, .1030, .0973));
   p3 += dot(p3, p3.yzx+33.33);
   return fract((p3.xxy+p3.yzz)*p3.zyx); 
}

vec2 triangle_wave(vec2 a,float scale,vec3 h1){
    
    return abs(fract((a+c1.xy+h1.xy)*scale)-.5);
}
void main( void ) 
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    gl_FragColor = vec4(0.0);
    vec3 col;  
    float t1 = .5;
    float scale = 1.1;
    //float scale2 = .25;
    vec3 h1 = hash31(floor(iTime/5.0))*5.0;
    float scale2 = h1.z+.5;
    vec2 uv1 = (gl_FragCoord.xy-iResolution.xy)/iResolution.xy/t1/2.0;
    uv1 += vec2(iTime/2.0,iTime/3.0)/t1/8.0; 
    vec2 uv = uv1; 
    for(int c=0;c<6;c++){
        uv = triangle_wave(uv,scale,h1);
        uv = triangle_wave(uv+col.xy,scale,h1);
        //offset /= scale2;
        uv.y /= -1.0;
        uv = uv.yx;
        col[c] = fract((uv.x)-(uv.y));
        col = col.yzx;
	}
    
    gl_FragColor = vec4(vec3(col),1.0);
    
}
